
(function (that) {
	var disableScroll = false;

	// convert and set image paths
	var rawElm = document.getElementById('markdown-raw'),
		convElm = document.getElementById('markdown-output');
	convElm.innerHTML = marked(rawElm.innerHTML.trim()).replace(/img src=\"([^\"]+)\"/g, "img src=\"imgs/$1\"");

	// move images into boxes
	var $imgs = convElm.getElementsByTagName('img');
	for (var i = $imgs.length - 1; i >= 0; i--) {
		var $pargParent = $imgs[i].parentNode;
		var $imgBox = document.createElement('figure');
		$imgBox.classList.add('img-box');

		// set the box as (instead of the element)
		$pargParent.insertBefore($imgBox, $imgs[i]);
		$imgBox.appendChild($imgs[i]);

		// add the captions
		var $caption = document.createElement('figcaption');
		$caption.innerHTML = $imgs[i].getAttribute('alt');

		// left side?
		if($imgs[i].hasAttribute('title') && $imgs[i].title === 'left') {
			$imgBox.style.float = 'left';
			$imgs[i].removeAttribute('title');
		}

		$imgBox.appendChild($caption);
	}

	// emojis cuz why not
	emojify.setConfig({img_dir: 'imgs/emojicons/src/images/emoji'})
	emojify.run(convElm);

	// scrolling stuff!
	var $mainContent = document.getElementById('main-content'),
		backPos = 0,
		MouseWheelHandler = function(e) {
			if(disableScroll) { return; }

			var e = window.event || e,
				isDownScroll = (e.wheelDelta || -e.detail) < 0,
				beforePos = backPos,
				changePct = 0.6;

			backPos = isDownScroll ? Math.min(backPos + changePct, 100) : Math.max(0, backPos - changePct);

			TweenLite.fromTo($mainContent, 1,
				{	css: {'background-position': beforePos + "% 0%"}						},
				{	css: {'background-position': backPos + "% 0p%"}, ease: Linear.easeNone	});
		};

	if ($mainContent.addEventListener) {
		// IE9, Chrome, Safari, Opera
		$mainContent.addEventListener("mousewheel", MouseWheelHandler, false);
		// Firefox
		$mainContent.addEventListener("DOMMouseScroll", MouseWheelHandler, false);
	}
	// IE 6/7/8
	else $mainContent.attachEvent("onmousewheel", MouseWheelHandler);

	var clickButton = document.querySelector('button');

	clickButton.onclick = function () {
		disableScroll = !disableScroll;
		if(disableScroll) {
			clickButton.innerText = "Move me!";
		}
		else {
			clickButton.innerText = "I'm dizzy!";
		}
	}

})(window);
